import React from 'react';
import { mount } from 'enzyme';
import LabelItem from './label-item';

describe('Label list item component', () => {
    test('should render with model', () => {
        const label = { id: 'EnvironmentLabel1', title: 'Label1', color: '#aabbcc' };
        const onClickLabel = jest.fn();

        const item = mount(<LabelItem envLabel={label} onClickLabel={onClickLabel} />);
        const title = item.find('.label-box');

        expect(title.text()).toBe('Label1');
        expect(title.prop('style')).toHaveProperty('backgroundColor', '#aabbcc');
    });

    test('should use callbacks', () => {
        const label = { id: 'EnvironmentLabel1', title: 'Label1', color: '#aabbcc' };
        const onClickLabel = jest.fn();

        const item = mount(<LabelItem envLabel={label} onClickLabel={onClickLabel} />);
        const title = item.find('.label-box');
        title.simulate('click');
        expect(onClickLabel).toHaveBeenCalledTimes(1);
    });
});
