import { applicationForm, initialState } from './application-form.reducer';
import { allApplications, applicationFormWithApplicationSet, environments, stage } from '../__mocks__/application-list.mocks';

const {
    setApplicationFolder,
    setApplication,
    setApplications,
    setEnvironments,
    setStages,
    onFormClean,
    initForm,
    onSave,
    onUpdate,
    cancelForm,
    pristineFormChange,
} = applicationForm.actions;
describe('Application form reducer', () => {
    const application = {
        id: 'Application1',
        title: 'Application1',
        folderId: 'Folder42',
        environments: [],
    };

    it('should have initial state', () => {
        expect(applicationForm.name).toBe('applicationForm');
        expect(applicationForm.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set application', () => {
        const folderId = 'Folder42';
        const state = applicationForm.reducer(initialState, setApplication(application));
        expect(state.application).toMatchObject(application);
        expect(state.application.folderId).toBe(folderId);
    });

    it('should set environments', () => {
        const state = applicationForm.reducer(initialState, setEnvironments(environments));
        expect(state.environments).toMatchObject(environments);
    });

    it('should set stages', () => {
        const state = applicationForm.reducer(initialState, setStages([stage]));
        expect(state.stages).toMatchObject([stage]);
    });

    it('should set applications', () => {
        const state = applicationForm.reducer(initialState, setApplications(allApplications));
        expect(state.applications).toMatchObject(allApplications);
    });

    it('should clean application when onFormClean', () => {
        const state = applicationForm.reducer(applicationFormWithApplicationSet, onFormClean);
        expect(state.application).toMatchObject(initialState.application);
    });

    it('should set application folder', () => {
        const state = applicationForm.reducer(applicationFormWithApplicationSet, setApplicationFolder('testFolder'));
        expect(state.application.folderId).toStrictEqual('testFolder');
    });

    it('init should not update state', () => {
        const state = applicationForm.reducer(initialState, initForm);
        expect(state).toStrictEqual(initialState);
    });

    it('onSave should not update state', () => {
        const state = applicationForm.reducer(initialState, onSave(application));
        expect(state).toStrictEqual(initialState);
    });

    it('onUpdate should not update state', () => {
        const state = applicationForm.reducer(initialState, onUpdate({ app: application, folderId: '' }));
        expect(state).toStrictEqual(initialState);
    });

    it('cancel should not update state', () => {
        const state = applicationForm.reducer(initialState, cancelForm);
        expect(state).toStrictEqual(initialState);
    });

    it('pristineChanged should not update state', () => {
        const state = applicationForm.reducer(initialState, pristineFormChange);
        expect(state).toStrictEqual(initialState);
    });
});
