import React from 'react';
import { SidebarEnvironmentList } from './sidebar-environment-list';
import { formApplications, formEnvironments, formStages } from '../../__mocks__/application-list.mocks';
import { mountWithStoreAndTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { DotInputSelect, DotInputText } from '@digital-ai/dot-components';

describe('SidebarEnvironmentList component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const clickEnvironment = jest.fn();

    const beginState = {
        applicationList: {
            applications: formApplications,
            deleteModalIsOpen: false,
        },
        folderId: '',
        applicationForm: {
            stages: formStages,
            environments: formEnvironments,
            application: formApplications[0],
            applications: formApplications,
        },
    };
    const mount = () => {
        wrapper = mountWithStoreAndTheme(
            <SidebarEnvironmentList
                {...{
                    environments: formEnvironments,
                    onClickEnvironment: clickEnvironment,
                    stages: formStages,
                }}
            />,
            dispatch,
            { ...beginState },
        );
    };

    const environmentSidebarListContainer = '.environment-item-container';

    beforeEach(() => {
        mount();
    });

    it('should initialize state', () => {
        expect(wrapper.find(DotInputSelect).prop('defaultValue')).toBe('Filter by stage...');
    });

    it('should deal with filters', () => {
        const environmentsOnScreen = wrapper.find(environmentSidebarListContainer);
        expect(environmentsOnScreen).toHaveLength(2);

        // change name of environment to filter
        const filter = wrapper.find(DotInputText);
        filter.invoke('onChange')({ target: { value: 'not found' } } as never);
        wrapper.update();
        expect(wrapper.find(environmentSidebarListContainer)).toHaveLength(0);
        filter.invoke('onChange')({ target: { value: '' } });
        wrapper.update();
        expect(wrapper.find(environmentSidebarListContainer)).toHaveLength(2);

        // change the stage filter
        const select = wrapper.find(DotInputSelect);
        select.invoke('onChange')({ target: { value: 'Test' } });
        wrapper.update();
        expect(wrapper.find(environmentSidebarListContainer)).toHaveLength(1);
    });

    it('should handle the callbacks', () => {
        const select = wrapper.find(DotInputSelect);
        select.invoke('onChange')({ target: { value: 'Test' } });
        wrapper.update();
        const environmentsOnScreen = wrapper.find(environmentSidebarListContainer);
        environmentsOnScreen.simulate('click');
        expect(clickEnvironment).toHaveBeenCalledWith(formEnvironments[1]);
    });
});
