import { environmentForm, initialState } from './environment-form.reducer';
import { env } from '../__mocks__/environment-list.mocks';
import { environment } from '../../application/__mocks__/application-list.mocks';

const { setEnvironmentModel, setSaveEnabled, cancelForm, initForm, saveForm, pristineFormChanged } = environmentForm.actions;

describe('Environments form reducer', () => {
    it('should have initial state', () => {
        expect(environmentForm.name).toBe('environmentForm');
        expect(environmentForm.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set environmentModel', () => {
        const state = environmentForm.reducer(initialState, setEnvironmentModel(env));
        expect(state.environmentModel).toMatchObject(env);
    });

    it('should set save enabled flag', () => {
        const state = environmentForm.reducer(initialState, setSaveEnabled(true));
        expect(state.saveEnabled).toBe(true);
    });

    it('cancel should not update state', () => {
        const state = environmentForm.reducer(initialState, cancelForm);
        expect(state).toStrictEqual(initialState);
    });

    it('pristineChanged should not update state', () => {
        const state = environmentForm.reducer(initialState, pristineFormChanged);
        expect(state).toStrictEqual(initialState);
    });

    it('init should not update state', () => {
        const state = environmentForm.reducer(initialState, initForm({ envId: '1', folderId: '' }));
        expect(state).toStrictEqual(initialState);
    });

    it('cancel should not update state', () => {
        const state = environmentForm.reducer(initialState, saveForm(environment));
        expect(state).toStrictEqual(initialState);
    });
});
