import React from 'react';
import isEmpty from 'lodash/isEmpty';
import { DotButton } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { useAppDispatch, useAppSelector } from '@xlr-ui/app/js/hooks';
import { environmentForm } from '../ducks/environment-form.reducer';
import { getFormEnvironmentModel, getFormSaveEnabled } from '../ducks/environment-list.selectors';

export interface EnvironmentEditHeaderProps {
    environmentId: string;
    folderId: string;
}

const { saveForm, cancelForm } = environmentForm.actions;
export const EnvironmentEditHeaderComponent = ({ environmentId, folderId }: EnvironmentEditHeaderProps) => {
    const dispatch = useAppDispatch();

    const saveEnabled = useAppSelector(getFormSaveEnabled);
    const environment = useAppSelector(getFormEnvironmentModel);

    const onCancel = () => {
        dispatch(cancelForm(folderId));
    };

    const onSave = () => {
        dispatch(saveForm({ ...environment, folderId }));
    };

    const caption = isEmpty(environmentId) ? 'Create' : 'Save';
    return (
        <ActionToolbarPortalContainer helpLink="how-to/using-environments">
            <DotButton onClick={onCancel} type="text">
                Cancel
            </DotButton>
            <DotButton data-testid={'edit-action'} disabled={!saveEnabled} onClick={onSave}>
                {caption}
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
