import LabelItem, { ComponentSize } from './label-item';
import React, { useEffect, useRef } from 'react';
import { Popover } from 'antd';

import './label-list-truncated.less';
import { Label } from '../../../application-list.types';

interface LabelListTruncatedProps {
    labels: Array<Label>;
}

const LabelListTruncated = ({ labels }: LabelListTruncatedProps) => {
    const containerRef = useRef<HTMLDivElement>(null);
    const labelRefs = useRef<HTMLDivElement[]>([]);

    const [exceedingWidthLabels, setExceedingWidthLabels] = React.useState<HTMLDivElement[]>([]);

    useEffect(() => {
        const overflownElements: HTMLDivElement[] = [];
        let remainingWidth = (containerRef.current?.getBoundingClientRect().width ?? 0) * 0.75; // leave space for "more" label

        labelRefs.current.forEach((label, _) => {
            const widthOfLabel = label.getBoundingClientRect().width;
            if (widthOfLabel > remainingWidth) {
                overflownElements.push(label);
                remainingWidth = 0;
            } else {
                remainingWidth -= widthOfLabel;
            }
        });
        setExceedingWidthLabels(overflownElements);
    }, [labels]);

    const renderPopupContent = () => {
        return (
            <div className="type-popup-content">
                {labels.slice(labels.length - exceedingWidthLabels.length).map((label, _) => (
                    <LabelItem envLabel={label} key={label.id} size={ComponentSize.Small} />
                ))}
            </div>
        );
    };

    const renderLabelListPopup = () => {
        return (
            exceedingWidthLabels.length !== 0 && (
                <Popover arrowPointAtCenter content={renderPopupContent()} overlayClassName="type-popup" placement="bottomRight" trigger="hover">
                    <div className="more-labels">more...</div>
                </Popover>
            )
        );
    };

    return (
        <div className="label-list" ref={containerRef}>
            {labels.map((label, index) => (
                <div
                    key={label.id}
                    ref={(element: HTMLDivElement) => {
                        if (element !== null) {
                            labelRefs.current[index] = element;
                        }
                    }}
                >
                    <LabelItem envLabel={label} key={label.id} size={ComponentSize.Small} />
                </div>
            ))}
            {renderLabelListPopup()}
        </div>
    );
};

export default LabelListTruncated;
