/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserProfileService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesUserProfileResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesUserProfileResource.class);
    private PermissionChecker permissions;
    private UserProfileService userProfileService;

    public FixturesUserProfileResource(PermissionChecker permissions, UserProfileService userProfileService) {
        this.permissions = permissions;
        this.userProfileService = userProfileService;
    }

    @Path(value="/userProfile")
    @GET
    public Response searchUserProfile(@QueryParam(value="name") String username, @QueryParam(value="email") String userEmail, @QueryParam(value="fullName") String fullName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        UserProfile profile = this.userProfileService.findByUsername(username);
        if (profile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean sameEmail = Objects.equals(profile.getEmail(), userEmail);
        boolean sameFullName = Objects.equals(profile.getFullName(), fullName);
        return sameEmail && sameFullName ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/userProfile")
    @POST
    public void createUserProfile(UserProfile userProfile) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating user profile: %s", userProfile.getName()));
        this.userProfileService.save(userProfile);
    }

    @Path(value="/userProfiles")
    @POST
    public void createUserProfiles(List<UserProfile> userProfiles) {
        logger.debug("Creating user profiles");
        userProfiles.forEach(this::createUserProfile);
    }

    @Path(value="/userProfile")
    @PUT
    public void updateUserProfile(UserProfile userProfile) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Updating user profile: %s", userProfile.getName()));
        this.userProfileService.save(userProfile);
    }

    @Path(value="/userProfile/{username:.*}")
    @DELETE
    public void deleteUserProfile(@PathParam(value="username") String username) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting user profile: %s", username));
        this.userProfileService.deleteByUsername(username);
    }
}

