package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.GateTask
import groovy.transform.TypeChecked

@TypeChecked
class GateTaskSpec extends TaskSpec<GateTask> {

  GateTaskSpec(String title = null) {
    super(title, Type.valueOf(GateTask))
  }

  void conditions(@DelegatesTo(value = ConditionsDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    configurationItem.conditions.addAll(ConditionsDelegate.delegate(new ConditionsDelegate(), cl))
  }

  void dependencies(@DelegatesTo(value = DependenciesDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    configurationItem.dependencies.addAll(DependenciesDelegate.delegate(new DependenciesDelegate(), cl))
  }

}