package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.{ActivityLogEntry, GroovyScriptTask}
import com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_SCRIPT_UPDATED
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import java.util.Date


@Component
class GroovyScriptTaskFieldsComparator @Autowired()(defaultTaskFieldsComparator: DefaultTaskFieldsComparator)
  extends TaskFieldsComparator[GroovyScriptTask] {

  override def getTaskClass: Class[GroovyScriptTask] = classOf[GroovyScriptTask]

  override def getLogs(timestamp: Date, username: String, original: GroovyScriptTask, updated: GroovyScriptTask): util.List[ActivityLogEntry] = {
    val updatedLogs: util.List[ActivityLogEntry] = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated)

    if (original.getScript != updated.getScript) {
      updatedLogs.add(TASK_SCRIPT_UPDATED.create(timestamp, username, original.getTaskType, original.getId, updated.getTitle, original.getScript, updated.getScript))
    }
    updatedLogs
  }
}
