package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Link
import com.xebialabs.xlrelease.domain.ParallelGroup
import groovy.transform.TypeChecked

@TypeChecked
class ParallelGroupSpec extends TaskGroupSpec<ParallelGroup> {

  List links = []

  ParallelGroupSpec(String title = null) {
    super(title, Type.valueOf(ParallelGroup))
  }

  void links(@DelegatesTo(value = LinksDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    links += LinksDelegate.delegate(new LinksDelegate(), cl)
  }

  @NoDoc
  @Override
  protected void postProcess() {
    super.postProcess()
    createLinks()
  }

  private createLinks() {
    try {
      def tasksByTitle = configurationItem.tasks.groupBy { it.title }

      configurationItem.links += (links as List<Tuple2<String, String>>).collect {
        def source = tasksByTitle[it.first].first()
        def target = tasksByTitle[it.second].first()

        new Link(source, target)
      }
    } catch (all) {
      throw new IllegalStateException("Unable to create links for parallel group '${configurationItem.title}'", all)
    }
  }
}