package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import groovy.transform.TypeChecked

@TypeChecked
class TileReleaseExtensionSpec extends ReleaseExtensionSpec<Tile> {
  TileReleaseExtensionSpec(String title, Type ciType) {
    super(ciType)
    this.title(title)
  }

  /**
   * Name given to this tile.
   *
   * @param title
   */
  void title(String title) {
    configurationItem.title = title
  }

  /**
   * Width of the tile.
   *
   * @param width
   */
  void width(Integer width) {
    configurationItem.width = width
  }

  /**
   * Row of the tile.
   *
   * @param row
   */
  void row(Integer row) {
    configurationItem.row = row
  }

  /**
   * Column of the tile.
   *
   * @param col
   */
  void col(Integer col) {
    configurationItem.col = col
  }
}