package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.variables.Variable
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of Variable
 */
@TypeChecked
class VariablesDelegate extends CollectionDelegate<Release, Variable> {

  /**
   * Creates a StringVariable with name and properties inside variables for a Release.
   */
  StringVariableSpec stringVariable(String name = null,
                                    @DelegatesTo(value = StringVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new StringVariableSpec(name), cl)
  }

  /**
   * Creates a StringVariable with name, value and default properties inside variables for a Release.
   *
   * @see #stringVariable(String, groovy.lang.Closure)
   */
  void stringVariable(String name, String value = null) {
    def spec = stringVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a ListBoxVariable with name and properties inside variables for a Release.
   */
  ListBoxVariableSpec listBoxVariable(String name = null,
                                      @DelegatesTo(value = ListBoxVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new ListBoxVariableSpec(name, (List<Variable>) getPlanItems()), cl)
  }

  /**
   * Creates a ListBoxVariable with name, value and default properties inside variables for a Release.
   *
   * @see #listBoxVariable(String, groovy.lang.Closure)
   */
  void listBoxVariable(String name, String value = null) {
    def spec = listBoxVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a IntegerVariable with name and properties inside variables for a Release.
   */
  IntegerVariableSpec integerVariable(String name = null,
                                      @DelegatesTo(value = IntegerVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new IntegerVariableSpec(name), cl)
  }

  /**
   * Creates a IntegerVariable with name, value and default properties inside variables for a Release.
   *
   * @see #integerVariable(String, groovy.lang.Closure)
   */
  void integerVariable(String name, int value = 0) {
    def spec = integerVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a BooleanVariable with name and properties inside variables for a Release.
   */
  BooleanVariableSpec booleanVariable(String name = null,
                                      @DelegatesTo(value = BooleanVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new BooleanVariableSpec(name), cl)
  }

  /**
   * Creates a BooleanVariable with name, value and default properties inside variables for a Release.
   *
   * @see #booleanVariable(String, groovy.lang.Closure)
   */
  void booleanVariable(String name, boolean value = null) {
    def spec = booleanVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a ListVariable with name and properties inside variables for a Release.
   */
  ListStringVariableSpec listVariable(String name = null,
                                      @DelegatesTo(value = ListStringVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new ListStringVariableSpec(name), cl)
  }

  /**
   * Creates a ListVariable with name, value and default properties inside variables for a Release.
   *
   * @see #listVariable(String, groovy.lang.Closure)
   */
  void listVariable(String name, String... value = null) {
    def spec = listVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a MultiSelectListBoxVariable with name and properties inside variables for a Release.
   */
  MultiSelectListBoxVariableSpec multiSelectListBoxVariable(String name = null,
                                                            @DelegatesTo(value = MultiSelectListBoxVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new MultiSelectListBoxVariableSpec(name, (List<Variable>) getPlanItems()), cl)
  }

  /**
   * Creates a MultiSelectListBoxVariable with name, value and default properties inside variables for a Release.
   *
   * @see #multiSelectListBoxVariable(String, groovy.lang.Closure)
   */
  void multiSelectListBoxVariable(String name, String... value = null) {
    def spec = multiSelectListBoxVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a SetVariable with name and properties inside variables for a Release.
   */
  SetStringVariableSpec setVariable(String name = null,
                                    @DelegatesTo(value = SetStringVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new SetStringVariableSpec(name), cl)
  }

  /**
   * Creates a SetVariable with name, value and default properties inside variables for a Release.
   *
   * @see #setVariable(String, groovy.lang.Closure)
   */
  void setVariable(String name, String... value = null) {
    def spec = setVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a MapVariable with name and properties inside variables for a Release.
   */
  MapStringStringVariableSpec mapVariable(String name = null,
                                          @DelegatesTo(value = MapStringStringVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new MapStringStringVariableSpec(name), cl)
  }

  /**
   * Creates a MapVariable with name, value and default properties inside variables for a Release.
   *
   * @see #mapVariable(String, groovy.lang.Closure)
   */
  void mapVariable(String name, Map<String, String> value = null) {
    def spec = mapVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a PasswordVariable with name and properties inside variables for a Release.
   */
  PasswordStringVariableSpec passwordVariable(String name = null,
                                              @DelegatesTo(value = PasswordStringVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new PasswordStringVariableSpec(name), cl)
  }

  /**
   * Creates a PasswordVariable with name, value and default properties inside variables for a Release.
   *
   * @see #passwordVariable(String, groovy.lang.Closure)
   */
  void passwordVariable(String name, String value = null) {
    def spec = passwordVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

  /**
   * Creates a DateVariable with name and properties inside variables for a Release.
   */
  DateVariableSpec dateVariable(String name = null,
                                @DelegatesTo(value = DateVariableSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new DateVariableSpec(name), cl)
  }

  /**
   * Creates a DateVariable with name, value and default properties inside variables for a Release.
   *
   * @see #dateVariable(String, groovy.lang.Closure)
   */
  void dateVariable(String name, Date value = null) {
    def spec = dateVariable(name, {
      showOnReleaseStart(true)
      required(true)
    })
    spec.value(value)
  }

}