package com.xebialabs.xlrelease.dsl.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

class CiTreeVisitor {
    private ConfigurationItem root;
    private Set<ConfigurationItem> visitedCis = new HashSet<>();

    private CiTreeVisitor(ConfigurationItem root) {
        this.root = root;
    }

    public static CiTreeVisitor of(ConfigurationItem root) {
        return new CiTreeVisitor(root);
    }

    public void with(VisitAction action) {
        visit(root, action);
    }

    private void visit(ConfigurationItem ci, VisitAction action) {
        if (null != ci && !visitedCis.contains(ci)) {
            visitedCis.add(ci);
            action.execute(ci);
            ci.getType().getDescriptor().getPropertyDescriptors().forEach(pd -> {
                    switch (pd.getKind()) {
                        case CI:
                            ConfigurationItem ciToVisit = ci.getProperty(pd.getName());
                            checkIdentity(ciToVisit, ci, pd);
                            visit(ciToVisit, action);
                            break;
                        case LIST_OF_CI:
                        case SET_OF_CI:
                            Collection<ConfigurationItem> cis = ci.getProperty(pd.getName());
                            cis.forEach(item -> {
                                checkIdentity(item, ci, pd);
                                visit(item, action);
                            });
                            break;
                    }
                }
            );
        }
    }

    private void checkIdentity(final ConfigurationItem ciToVisit, final ConfigurationItem ci, final PropertyDescriptor pd) {
        if (ciToVisit != null && ciToVisit.getId() == null) {
            throw new IllegalStateException(String.format("Property '%s' of CI '%s' has null ID", pd.getFqn(), ci.getId()));
        }
    }

    @FunctionalInterface
    interface VisitAction {
        void execute(ConfigurationItem ci);
    }
}
