package com.xebialabs.xlrelease.dsl.service;

import java.util.Optional;

public class PathUtils {

    public static Optional<String> folderPath(final String fullReleasePath) {
        String safePath = encode(fullReleasePath);
        int lastSlashIndex = safePath.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return Optional.of(decode(safePath.substring(0, lastSlashIndex)));
        }
        return Optional.empty();
    }

    public static Optional<String> releasePath(final String fullReleasePath) {
        String safePath = encode(fullReleasePath);
        int lastSlashIndex = safePath.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return Optional.of(decode(safePath.substring(lastSlashIndex + 1, safePath.length())));
        }
        return Optional.of(fullReleasePath);
    }

    private static String encode(final String path) {
        return path.replace("\\/", "&#47;");
    }

    private static String decode(final String path) {
        return path.replace("&#47;", "\\/");
    }
}
