package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Phase
import com.xebialabs.xlrelease.domain.status.PhaseStatus
import com.xebialabs.xlrelease.domain.status.TaskStatus
import groovy.transform.TypeChecked

@TypeChecked
class PhaseSpec extends PlanItemSpec<Phase> {

  PhaseSpec(String title = null) {
    super(Type.valueOf(Phase))
    Phase phase = configurationItem
    phase.setTitle(title ?: "Phase")
  }

  /**
   * The color of the phase top bar in the UI.
   * Format: #(hex value); for example '#3D6C9E'
   */
  void color(String color) {
    configurationItem.color = color
  }

  /**
   * Set the status of a Phase.
   */
  void status(PhaseStatus status) {
    configurationItem.setStatus(status)
  }

  /**
   * Creates tasks inside a phase for a release.
   */
  void tasks(@DelegatesTo(value = TasksDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    Phase phase = this.configurationItem
    phase.tasks = TasksDelegate.delegate(new TasksDelegate(phase), cl)
    phase.tasks.each { it.setStatus(TaskStatus.PLANNED) }
  }

}

