package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Team
import groovy.transform.TypeChecked

@TypeChecked
class TeamSpec extends ConfigurationItemSpec<Team> {

  TeamSpec(String teamName = null) {
    super(Type.valueOf(Team))
    configurationItem.teamName = teamName
  }

  void teamName(String teamName) {
    configurationItem.teamName = teamName
  }

  void roles(String... roles) {
    configurationItem.roles = (roles as Set) as List
  }

  void members(String... members) {
    configurationItem.members = (members as Set) as List
  }

  void permissions(String... permissions) {
    configurationItem.permissions = (permissions as Set) as List
  }
}
