package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.{FolderService, ReleaseService}

trait PathRenderingSupport {

  def releaseService: ReleaseService

  def folderService: FolderService

  def renderFolder(releaseId: String): String = {
    def renderFolderPath(titles: String, folderId: String): String = {
      folderId match {
        case id if id == Ids.ROOT_FOLDER_ID => titles
        case id if id.contains("/") =>
          val title = if (Ids.isReleaseId(id)) {
            releaseService.getTitle(id)
          } else {
            folderService.getTitle(id)
          }
          renderFolderPath(s"$title/$titles", id.substring(0, id.lastIndexOf("/")))
      }
    }

    renderFolderPath("", Ids.findFolderId(releaseId))
  }
}
