package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.*
import groovy.transform.TypeChecked

@TypeChecked
abstract class CollectionDelegate<C extends PlanItem, U extends ConfigurationItem> {
  List<U> planItems = []
  C container
  List<VariableRefSpec> variableRefSpecs = []

  CollectionDelegate(C container = null) {
    this.container = container
  }

  def <T extends ConfigurationItemSpec<U>> T delegate(T configurationItemSpec, Closure cl) {
    def code = cl.rehydrate(configurationItemSpec, configurationItemSpec, configurationItemSpec)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    // connect phase to release
    connectToContainer(configurationItemSpec)
    code()
    // connect CI to container (again) because it might be new CI with adjusted type (because of ConfigurationItemSpec.setType)
    connectToContainer(configurationItemSpec)
    configurationItemSpec.postProcess()
    U item = configurationItemSpec.getConfigurationItem()
    planItems.add(item)
    if (configurationItemSpec instanceof VariableSpec && configurationItemSpec.variableRefSpec) {
      variableRefSpecs << configurationItemSpec.variableRefSpec
    }
    configurationItemSpec
  }

  private void connectToContainer(ConfigurationItemSpec configurationItemSpec) {
    if (null != container) {
      def ci = configurationItemSpec.configurationItem
      // TODO: figure out if we can get rid of this case-o-logy
      switch (ci) {
        case Phase:
          Phase phase = ci as Phase
          phase.setRelease(container as Release)
          break
        case TaskGroup:
        case Task:
          Task task = ci as Task
          task.setContainer(container as TaskContainer)
          break
      }
    }
  }

  static <C extends PlanItem, U extends ConfigurationItem> List<U> delegate(CollectionDelegate<C, U> collectionDelegate, Closure cl) {
    def code = cl.rehydrate(collectionDelegate, collectionDelegate, collectionDelegate)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    code()
    collectionDelegate.planItems
  }
}
