/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import java.util.Optional;

public class PathUtils {
    public static Optional<String> folderPath(String fullReleasePath) {
        String safePath = PathUtils.encode(fullReleasePath);
        int lastSlashIndex = safePath.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return Optional.of(PathUtils.decode(safePath.substring(0, lastSlashIndex)));
        }
        return Optional.empty();
    }

    public static Optional<String> releasePath(String fullReleasePath) {
        String safePath = PathUtils.encode(fullReleasePath);
        int lastSlashIndex = safePath.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return Optional.of(PathUtils.decode(safePath.substring(lastSlashIndex + 1, safePath.length())));
        }
        return Optional.of(fullReleasePath);
    }

    private static String encode(String path) {
        return path.replace("\\/", "&#47;");
    }

    private static String decode(String path) {
        return path.replace("&#47;", "\\/");
    }
}

