package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.dsl.service.DslService
import groovy.transform.TypeChecked

@TypeChecked
class ImportXlrSpec {

  private DslService dslService
  private String destinationFolderId
  private Object context

  ImportXlrSpec(Object context, DslService dslService, String destinationFolderId) {
    this.context = context
    this.dslService = dslService
    this.destinationFolderId = destinationFolderId
  }

  /**
   * Creates a Template with title and properties.
   *
   * @see #template(groovy.lang.Closure)
   */
  Release template(String title = null, @DelegatesTo(value = TemplateSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def templateSpec = new TemplateSpec(title)
    Release template = TemplateSpec.delegate(templateSpec, cl)
    def additionalProperties = templateSpec.getAdditionalProperties()
    Release createdTemplate = dslService.importTemplate(template, destinationFolderId, additionalProperties)
    createdTemplate
  }

  /**
   * Creates a Template with title and properties.
   *
   * @see #template(groovy.lang.Closure)
   */
  Release release(String title = null, @DelegatesTo(value = TemplateSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def templateSpec = new TemplateSpec(title)
    Release template = TemplateSpec.delegate(templateSpec, cl)
    def additionalProperties = templateSpec.getAdditionalProperties()
    Release createdTemplate = dslService.importTemplate(template, destinationFolderId, additionalProperties)
    createdTemplate
  }


}
