package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import groovy.transform.TypeChecked

@TypeChecked
class TemplateBuilder {

  /**
   * Creates a Template with title and properties.
   *
   * @see #template(groovy.lang.Closure)
   */
  Release template(String title = null, @DelegatesTo(value = TemplateSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    TemplateSpec.delegate(new TemplateSpec(title), cl)
  }
}