package com.xebialabs.xlrelease.dsl.resolver

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.delivery.service.DeliveryService
import com.xebialabs.xlrelease.dsl.resolver.DeliveryTaskPathResolver.{deliveryIdField, folderIdField, patternIdField, stageIdField}
import com.xebialabs.xlrelease.dsl.service.renderer.PathRenderingSupport
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.{FolderService, ReleaseService}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.collection.mutable

@Component
class DeliveryTaskToPathResolver @Autowired()(val deliveryService: DeliveryService,
                                              val releaseService: ReleaseService,
                                              val folderService: FolderService)
  extends DeliveryTaskPathResolver with PathRenderingSupport {

  private val idResolvers: Seq[(String, Resolver)] = Seq(
    (deliveryIdField, deliveryIdResolver),
    (patternIdField, deliveryIdResolver),
    (stageIdField, stageIdResolver),
    (folderIdField, folderIdResolver)
  )

  def resolve(ci: ConfigurationItem, propertyName: String): Map[PropertyDescriptor, PathResolution] = resolveCi(ci, idResolvers.filter(_._1 == propertyName))

  override def resolve(ci: ConfigurationItem): Map[PropertyDescriptor, PathResolution] = resolveCi(ci, idResolvers)

  private def deliveryIdResolver(ci: ConfigurationItem, property: String, value: String, resolutions: mutable.Map[String, PathResolution]): String = {
    val delivery = deliveryService.getDeliveryOrPattern(value)
    s"${renderFolder(delivery.getFolderId)}${delivery.getTitle}"
  }

  private def stageIdResolver(ci: ConfigurationItem, property: String, value: String, resolutions: mutable.Map[String, PathResolution]): String = {
    val delivery = deliveryService.getDeliveryOrPattern(Ids.getParentId(value))
    val stageTitle = delivery.getStageByIdOrTitle(value).getTitle
    stageTitle
  }

  private def folderIdResolver(ci: ConfigurationItem, property: String, value: String, resolutions: mutable.Map[String, PathResolution]): String = {
    renderFolder(value).dropRight(1)
  }
}
