package com.xebialabs.xlrelease.dsl.service

import com.xebialabs.xlrelease.dsl.service.renderer.DslRenderer.{BEGIN_SCRIPT_TAG, END_SCRIPT_TAG}

private[service] object DslFormatter {
  val indentation = "  "

  def format(unformattedCode: String): String = {
    var lastStartingQuote: Option[Int] = None
    var depth = 0
    var insideScript = false
    var insideStringConcatenation = false
    var insideMultiLineString = false

    def indent(line: String): String = {
      insideScript = if (line.contains(BEGIN_SCRIPT_TAG)) {
        true
      } else {
        insideScript
      }

      val strippedLine = removeXlrDslTokens(line)

      val indentedLine = if (!insideScript) {

        if (line.trim.endsWith("}")) depth = depth - 1
        val indent = lastStartingQuote.map(" " * _).getOrElse(indentation * depth)
        if (line.trim.endsWith("{")) depth = depth + 1

        val indentedLine = indent + strippedLine

        if (indentedLine.trim.endsWith("'''\\")) {
          lastStartingQuote = Some(indentedLine.indexOf("'''"))
          insideMultiLineString = true
        }

        if (!insideMultiLineString && indentedLine.trim.endsWith("' +") && !insideStringConcatenation) {
          insideStringConcatenation = true
          lastStartingQuote = Some(indentedLine.indexOf("'"))
        }

        if (indentedLine.trim.endsWith("'''])")) {
          insideMultiLineString = false
          lastStartingQuote = None
        }

        if (!insideMultiLineString && insideStringConcatenation && indentedLine.trim.endsWith("'")) {
          insideStringConcatenation = false
          lastStartingQuote = None
        }
        indentedLine
      } else {
        if (line.contains(END_SCRIPT_TAG)) {
          insideScript = false
          lastStartingQuote = None
        }
        strippedLine
      }

      indentedLine
    }

    val indentedLines = for {
      line <- Predef.augmentString(unformattedCode).linesIterator
    } yield indent(line)
    indentedLines.mkString("\n")
  }

  def removeXlrDslTokens(input: String): String = {
    input.replace(BEGIN_SCRIPT_TAG, "").replace(END_SCRIPT_TAG, "")
  }
}
