package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Phase
import com.xebialabs.xlrelease.domain.PlanItem
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.domain.TaskGroup
import groovy.transform.TypeChecked

@TypeChecked
class TasksDelegate extends CollectionDelegate<PlanItem, Task> {

  TasksDelegate(Phase phase) {
    super(phase)
  }

  TasksDelegate(TaskGroup group) {
    super(group)
  }

  TaskSpec task(@DelegatesTo(value = TaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    this.task(null, cl)
  }

  /**
   * Creates a task with title and properties inside tasks for a release.
   */
  TaskSpec task(String title, @DelegatesTo(value = TaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    this.task(null, title, cl)
  }

  TaskSpec task(String type, String title, @DelegatesTo(value = TaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    Type xlType  = type == null ? Type.valueOf(Task) : Type.valueOf(type)
    super.delegate(new TaskSpec(title, xlType), cl)
  }

  TaskSpec manual(String title = null, @DelegatesTo(value = TaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    task(title, cl)
  }

  CreateReleaseTaskSpec createRelease(String title = null, @DelegatesTo(value = CreateReleaseTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new CreateReleaseTaskSpec(title), cl)
  }

  GateTaskSpec gate(String title = null, @DelegatesTo(value = GateTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new GateTaskSpec(title), cl)
  }

  NotificationTaskSpec notification(String title = null, @DelegatesTo(value = NotificationTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new NotificationTaskSpec(title), cl)
  }

  ScriptTaskSpec script(String title = null, @DelegatesTo(value = ScriptTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new ScriptTaskSpec(title), cl)
  }

  GroovyScriptTaskSpec groovyScript(String title = null, @DelegatesTo(value = GroovyScriptTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new GroovyScriptTaskSpec(title), cl)
  }

  ParallelGroupSpec parallelGroup(String title = null, @DelegatesTo(value = ParallelGroupSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new ParallelGroupSpec(title), cl)
  }

  SequentialGroupSpec sequentialGroup(String title = null, @DelegatesTo(value = SequentialGroupSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new SequentialGroupSpec(title), cl)
  }

  UserInputTaskSpec userInput(String title = null, @DelegatesTo(value = UserInputTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new UserInputTaskSpec(title), cl)
  }

  CustomScriptTaskSpec custom(String title = null, @DelegatesTo(value = CustomScriptTaskSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new CustomScriptTaskSpec(title), cl)
  }

}