package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.xlrelease.domain.BaseArtifact._
import com.xebialabs.xlrelease.domain.TemplateLogo
import org.springframework.stereotype.Component

@Component
class TemplateLogoRenderer extends BaseTypedCiRenderer[TemplateLogo]("logo") {

  override def ignoredProperties = List(CONTENT_TYPE_PROPERTY_NAME, EXPORT_FILENAME_PROPERTY_NAME, PORTABLE_FILENAME_PROPERTY_NAME)

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String = {
    s"""$dslKeyword("${ci.getProperty(SourceArtifact.FILE_URI_PROPERTY_NAME)}") {
       |filename "${ci.asInstanceOf[TemplateLogo].getPortableFilename}"
       |}""".stripMargin
  }
}
