package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.FolderService

trait PathRenderingSupport {

  def folderService: FolderService

  def renderFolder(containerId: String): String = {
    val extractedFolderId = Ids.findFolderId(containerId)
    if (extractedFolderId == Ids.ROOT_FOLDER_ID) {
      ""
    } else {
      val folderPaths = folderService.getPath(Ids.getName(extractedFolderId))
      folderPaths.mkString("", "/", "/").dropWhile(_ == '/')
    }

  }
}
