package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Comment
import groovy.transform.TypeChecked

/**
 * Groovy DSL spec for Comment.
 */
@TypeChecked
class CommentSpec extends ConfigurationItemSpec<Comment> {

  CommentSpec() {
    super(Type.valueOf(Comment))
    date(new Date())
  }

  /**
   * Set the comment text.
   */
  void text(String text) {
    configurationItem.text = text
  }

  /**
   * Set the comment author
   */
  void author(String author) {
    configurationItem.author = author
  }

  /**
   * Set the comment date.
   *
   * If not specified current date will be used.
   */
  void date(Date date) {
    configurationItem.date = date
  }
}

