package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.domain.facet.Facet
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of facets
 */
@TypeChecked
class FacetDelegate extends CollectionDelegate<Task, Facet> {
  FacetDelegate(Task task) {
    super(task)
  }

  FacetSpec facet(String facetType, @DelegatesTo(value = FacetSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new FacetSpec(Type.valueOf(facetType)), cl)
  }

  FacetSpec facet(@DelegatesTo(value = FacetSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new FacetSpec(Type.valueOf("xlrelease.DeploymentTaskFacet")), cl)
  }

}