package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.ScriptTask
import groovy.transform.TypeChecked
import org.codehaus.groovy.runtime.StringGroovyMethods

@TypeChecked
class ScriptTaskSpec extends TaskSpec<ScriptTask> {

  ScriptTaskSpec(String title = null) {
    super(title, Type.valueOf(ScriptTask))
  }

  void script(String script) {
    script.trim()
    configurationItem.script = script
  }

  void script(List<String> script) {
    configurationItem.script = StringGroovyMethods.stripIndent((CharSequence) script.join(""))
  }

  void script(String... script) {
    configurationItem.script = StringGroovyMethods.stripIndent((CharSequence) script.join(""))
  }
}
