package com.xebialabs.xlrelease.domain.tasks.groovy;

import com.xebialabs.xlrelease.builder.BaseScriptTaskBuilder;
import com.xebialabs.xlrelease.domain.GroovyScriptTask;

public class GroovyScriptTaskBuilder extends BaseScriptTaskBuilder<GroovyScriptTask, GroovyScriptTaskBuilder> {

    private String script;
    private int scriptTimeout;

    public GroovyScriptTaskBuilder withScript(String script) {
        this.script = script;
        return this;
    }

    public GroovyScriptTaskBuilder withScriptTimeout(int scriptTimeout) {
        this.scriptTimeout = scriptTimeout;
        return this;
    }

    @Override
    protected void setFields(GroovyScriptTask task) {
        super.setFields(task);
        task.setScript(script);
        task.setScriptTimeout(scriptTimeout);
    }

    @Override
    public GroovyScriptTask build() {
        GroovyScriptTask task = new GroovyScriptTask().getType().getDescriptor().newInstance("dummy");
        setFields(task);
        return task;
    }

    public static GroovyScriptTaskBuilder builder() {
        return new GroovyScriptTaskBuilder();
    }
}
