package com.xebialabs.xlrelease.dsl

import groovy.transform.TypeChecked

@TypeChecked
class DependencyTargetSpec implements TargetSpec {
  String release
  String phase
  String task

  /**
   * Specify a release title for the dependency.
   * By default only releases from the same folder will be checked.
   * For releases from other folders provide the full folder path and release title
   * like "Container folder name/Sub folder name/release title"
   *
   * @param release
   */
  void release(String release) {
    this.release = release
  }

  /**
   * Specify a phase title for the dependency.
   *
   * @param phase
   */
  void phase(String phase) {
    this.phase = phase
  }

  /**
   * Specify a task title for the dependency.
   *
   * @param task
   */
  void task(String task) {
    this.task = task
  }
}