package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.PlanItem
import com.xebialabs.xlrelease.domain.status.FlagStatus
import groovy.transform.TypeChecked

@TypeChecked
abstract class PlanItemSpec<T extends PlanItem> extends ConfigurationItemSpec<T> {

  PlanItemSpec(String title = null, final Type ciType) {
    super(ciType)
    this.title(title)
  }

  /**
   * The title of the item.
   */
  void title(String title) {
    configurationItem.title = title
  }

  /**
   * The description of the item.
   */
  void description(String desc) {
    configurationItem.description = desc
  }

  /**
   * Flags indicate that an item needs attention.
   *
   * @param flagStatus status
   * @param comment The reason the item is flagged.
   */
  void flag(FlagStatus flagStatus, String flagComment) {
    configurationItem.flagStatus = flagStatus
    configurationItem.flagComment = flagComment
  }

  /**
   * The owner of the item.
   */
  void owner(String owner) {
    configurationItem.owner = owner
  }

  /**
   * The date that the item is supposed to start.
   */
  void scheduledStartDate(Date scheduledStartDate) {
    configurationItem.scheduledStartDate = scheduledStartDate
  }

  /**
   * The date that the item is supposed to end.
   */
  void dueDate(Date dueDate) {
    configurationItem.dueDate = dueDate
  }

  /**
   * The actual start date.
   */
  void startDate(Date startDate) {
    configurationItem.startDate = startDate
  }

  /**
   * The actual end date
   */
  void endDate(Date endDate) {
    configurationItem.endDate = endDate
  }

  /**
   * The time that the item is supposed to take to complete, in seconds.
   */
  void plannedDuration(Integer plannedDuration) {
    // TODO: could be a human readable string - take it from typesafe config
    configurationItem.plannedDuration = plannedDuration
  }
}