package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.TaskGroup
import groovy.transform.TypeChecked

@TypeChecked
abstract class TaskGroupSpec<T extends TaskGroup> extends TaskSpec<T> {

  TaskGroupSpec(String title = null, Type t) {
    super(title, t)
  }

  void tasks(@DelegatesTo(value = TasksDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    TaskGroup group = this.getConfigurationItem() as TaskGroup
    group.tasks = TasksDelegate.delegate(new TasksDelegate(group), cl)
  }
}



