package com.xebialabs.xlrelease.dsl.service

import com.xebialabs.deployit.{ReleaseInfo, ServerConfiguration}
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.dsl.service.DslFormatter.format
import com.xebialabs.xlrelease.dsl.service.renderer.{DefaultRenderer, DslRendererContext, PathRenderingSupport}
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, Ids}
import com.xebialabs.xlrelease.service.{FolderService, ReleaseService}
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Date

@Component
class DslExporter @Autowired()(defaultRenderer: DefaultRenderer,
                               val releaseService: ReleaseService,
                               val folderService: FolderService,
                               val configurationRepository: ConfigurationRepository) extends PathRenderingSupport {

  @Timed
  def exportTemplate(template: Release, renderAsTemplate: Boolean = true): String = {
    val rendererContext = new DslRendererContext(renderAsTemplate, releaseService, folderService, configurationRepository)
    val templateDsl = addXlrTags(defaultRenderer.dsl(rendererContext, template))
    addMetaInformation(template, format(rendererContext.context() ++ templateDsl))
  }

  private def addXlrTags(templateDsl: String): String = {
    s"""xlr {
       |$templateDsl
       |}""".stripMargin
  }

  private def addMetaInformation(template: Release, templateDsl: String): String = {
    val templateId = Ids.releasePathInRootFolder(template.getId).replaceAll("/","-")
    val releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties")

    s"""|// Exported from:        ${ServerConfiguration.getInstance().getServerUrl}#/templates/$templateId/code
        |// Release version:      ${releaseInfo.getVersion}
        |// Date created:         ${new Date()}
        |
        |$templateDsl""".stripMargin
  }
}
