package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.xlrelease.domain.Attachment
import org.springframework.stereotype.Component

@Component
class AttachmentRenderer extends BaseTypedCiRenderer[Attachment]("attachment") {

  override def ignoredProperties = List("release", "contentType", "exportFilename")

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String = {
    s"""$dslKeyword("${ci.getProperty(SourceArtifact.FILE_URI_PROPERTY_NAME)}") {
       |filename "${ci.asInstanceOf[Attachment].getExportFilename}"
       |}""".stripMargin
  }
}
