package com.xebialabs.xlrelease.dsl.service.renderer

import com.google.common.base.CaseFormat.{LOWER_CAMEL, UPPER_CAMEL}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.ReleaseExtension
import org.springframework.stereotype.Component

@Component
class ReleaseExtensionRenderer extends BaseTypedCiRenderer[ReleaseExtension]("extension") {

  override def ignoredProperties = List("title")

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String = {
    val dslKeyword = UPPER_CAMEL.to(LOWER_CAMEL, ci.getType.getName)

    s"""|$dslKeyword${renderTitle(ci)} {
        |${renderProperties(rendererContext, ci)}
        |}""".stripMargin
  }
}
