package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.domain.PythonScript
import groovy.transform.TypeChecked

@TypeChecked
class ScriptDelegateSpec<T extends PythonScript> extends ConfigurationItemSpec<T> {
  List<VariableRefSpec> variableReferences = []

  ScriptDelegateSpec(CustomScriptTask customScriptTask) {
    super(Type.valueOf(PythonScript))
    def script = this.configurationItem as PythonScript
    script.customScriptTask = customScriptTask
  }

  /**
   * Utility function that creates a reference to the release variable.
   *
   * @param variableName name of the release variable
   */
  @NoDoc
  VariableRefSpec variable(String variableName) {
    def varRef = new VariableRefSpec(variableName)
    variableReferences.add(varRef)
    varRef
  }

}