package com.xebialabs.xlrelease.dsl


import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.status.FlagStatus

class TemplateSpec extends ReleaseSpec {
  TemplateSpec(String title = null) {
    super(title)
    Release release = configurationItem
    release.setTitle(title ?: "Template")
  }

  /**
   * Allow concurrent releases from trigger.
   */
  void allowConcurrentReleasesFromTrigger(boolean allowConcurrentReleasesFromTrigger) {
    Release release = configurationItem
    release.setAllowConcurrentReleasesFromTrigger(allowConcurrentReleasesFromTrigger)
  }

  /**
   * Defines multiple Triggers for a Template.
   */
  void releaseTriggers(@DelegatesTo(value = ReleaseTriggersDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    Release release = configurationItem
    release.releaseTriggers = ReleaseTriggersDelegate.delegate(new ReleaseTriggersDelegate(release), cl)
  }

  // release properties that are not used in templates
  @NoDoc
  @Override
  void flag(final FlagStatus flagStatus, final String flagComment) {}

  @NoDoc
  @Override
  void startDate(final Date startDate) {}

  @NoDoc
  @Override
  void endDate(final Date endDate) {}

  @NoDoc
  @Override
  void owner(final String owner) {}

  @NoDoc
  @Override
  void autoStart(final boolean autoStart) {}

  @NoDoc
  @Override
  void calendarPublished(final boolean calendarPublished) {}
}
