package com.xebialabs.xlrelease.lookup.delegate

import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.xlrelease.lookup.api.internal.LookupResultElement
import com.xebialabs.xlrelease.script.jython.{JythonScriptService, XlrJythonSupport}
import com.xebialabs.xlrelease.script.{DefaultScriptService, XlrScriptContext}
import grizzled.slf4j.Logger

import java.util.{List => JList, Map => JMap}

object JythonLookupDelegate extends ScriptLookupDelegate with XlrJythonSupport {

  // remove ugly '$' at the end of this singleton when logging
  override def logger: Logger = Logger(this.getClass.getName.dropRight(1))

  lazy val scriptService: DefaultScriptService = springBean[JythonScriptService]

  @Delegate(name = "jythonLookup")
  override def lookup(ci: ConfigurationItem, methodName: String, attrs: JMap[String, String], parameters: Parameters): JList[LookupResultElement] = {
    super.lookup(ci, methodName, attrs, parameters)
  }

  override def scriptSuffix: String = "py"

  override protected def doExecuteScript(scriptContext: XlrScriptContext): Unit = {
    executeScript(scriptContext)
  }
}
