package com.xebialabs.xlrelease.lookup.delegate

import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.xlrelease.lookup.api.internal.LookupResultElement
import com.xebialabs.xlrelease.script.groovy.GroovyScriptService
import com.xebialabs.xlrelease.script.{DefaultScriptService, XlrScriptContext}

import java.util.{List => JList, Map => JMap}

object GroovyLookupDelegate extends ScriptLookupDelegate {

  lazy val scriptService: DefaultScriptService = springBean[GroovyScriptService]

  @Delegate(name = "groovyLookup")
  override def lookup(ci: ConfigurationItem, methodName: String, attrs: JMap[String, String], parameters: Parameters): JList[LookupResultElement] = {
    super.lookup(ci, methodName, attrs, parameters)
  }

  override def scriptSuffix: String = "groovy"

  override protected def doExecuteScript(scriptContext: XlrScriptContext): Unit = {
    scriptService.executeScript(scriptContext)
  }
}
