package com.xebialabs.xlrelease.pendo.utils

import com.xebialabs.xlrelease.utils.DateVariableUtils.printDate
import grizzled.slf4j.Logging

import java.util.Date

object PendoUtils extends Logging {

  val PENDO_MAX_PROPERTY_LENGTH: Int = 1000

  implicit class PendoMap(val properties: Map[String, Any]) extends AnyVal {
    def toPendo: Map[String, Any] = {
      properties.view.mapValues {
        case s: String => if (s.length > PENDO_MAX_PROPERTY_LENGTH) s.substring(0, PENDO_MAX_PROPERTY_LENGTH) else s
        case date: Date => printDate(date)
        case default => default
      }.toMap
    }
  }

  def generatePendoVistorId(accountId: String, host: String): String = {
    s"${accountId}/${host}"
  }

  def splitPropertyList(stringList: List[String]): Array[String] = {
    val (firstList, limiterOpt) = getSublistAndLimiter(stringList)

    limiterOpt match {
      case Some(limiter) =>
        val secondStringList = stringList.splitAt(limiter)._2
        val (secondList, _) = getSublistAndLimiter(secondStringList)
        Array(firstList, secondList)
      case None => Array(firstList, "")
    }
  }

  private def getSublistAndLimiter(stringList: List[String]) = {
    val sb = new StringBuffer
    var limitingIndex: Option[Int] = None // the first one that didn't make it in

    for (i <- stringList.indices) {
      val string = stringList(i)
      if (sb.length() + string.length + 2 < PENDO_MAX_PROPERTY_LENGTH) { // 2 because we're gonna remove the ","
        sb.append(string)
        sb.append(",")
      } else if (limitingIndex eq None) {
        limitingIndex = Some(i)
      }
    }

    sb.length() match {
      case l if l > 0 =>
        val sbWithoutFinalComma = sb.substring(0, l - 1)
        (sbWithoutFinalComma, limitingIndex)
      case l if l == 0 => ("", None)
    }
  }

}
