package com.xebialabs.xlrelease.pendo

object PendoConstants {

  // Tracked events secret key
  val TRACKED_EVENT_INTEGRATION_KEY = "bee331a8-eb04-4939-636f-6dc1c077e3ca"
  val CLUSTER: String = "cluster"
  val GENERAL: String = "general"
  val DATA: String = "data"
  val INSTALLATION: String = "installation"
  val LICENSE: String = "license"
  val ANALYTICS: String = "analyticsdata"

  // XLRelease Pendo tracked events
  val RELEASE_ABORTED: String = "ReleaseAborted"
  val RELEASE_COMPLETED: String = "ReleaseCompleted"
  val RELEASE_CREATED: String = "ReleaseCreated"
  val RELEASE_FAILED: String = "ReleaseFailed"
  val RELEASE_STARTED: String = "ReleaseStarted"
  val RELEASE_METRICS: String = "ReleaseMetrics"
  val TASK_METRICS: String = "TaskMetrics"
  val USER_METRICS: String = "UserMetrics"
  val REPORT_METRICS: String = "ReportMetrics"
  val USAGE_METRICS: String = "UsageMetrics"
  val LICENSE_METRICS: String = "License"
  val ARCHIVE_METRICS: String = "ArchiveMetrics"
  val INSTALLATION_METRICS: String = "Installation"
  val WORKFLOW_METRICS: String = "WorkflowMetrics"

  val TIMESTAMP: String = "timestamp"
  val RELEASE_ID: String = "releaseId"

  // Release created tracked properties
  val CREATION_SOURCE: String = "source"

  // Release aborted/completed tracked properties
  val START_DATE: String = "startDate"
  val END_DATE: String = "endDate"
  val PLANNED_DURATION: String = "plannedDuration"
  val ACTUAL_DURATION: String = "actualDuration"
  val RISK_SCORE: String = "riskScore"
  val TASKS: String = "tasks"
  val PHASES: String = "phases"
  val VARIABLES: String = "variables"
  val VARIABLES_SIZE: String = "variablesSize"
  val ATTRIBUTES: String = "attributes"
  val EXTENSIONS: String = "extensions"
  val COMMENTS: String = "comments"
  val COMMENTS_SIZE: String = "commentsSize"
  val ATTACHMENTS: String = "attachments"
  val DEPENDENCIES: String = "dependencies"
  val TASK_FAILURES: String = "taskFailures"
  val PHASE_RESTARTS: String = "phaseRestarts"
  val TASK_TYPES_1: String = "taskTypes1"
  val TASK_TYPES_2: String = "taskTypes2"
  val AUTOMATED_TASKS: String = "automatedTasks"
  val AUTOMATION_PERCENTAGE: String = "automationPercentage"

  // Release metrics tracked properties
  val TEMPLATES: String = "templates"
  val TRIGGERS: String = "triggers"
  val ACTIVE_TRIGGERS: String = "activeTriggers"
  val PLANNED_RELEASES: String = "plannedReleases"
  val IN_PROGRESS_RELEASES: String = "inProgressReleases"
  val FAILING_RELEASES: String = "failingReleases"
  val FAILED_RELEASES: String = "failedReleases"
  val PAUSED_RELEASES: String = "pausedReleases"
  val COMPLETED_RELEASES: String = "completedReleases"
  val ABORTED_RELEASES: String = "abortedReleases"
  val RELEASES_LAST_24_HOURS: String = "releasesLast24Hours"
  val RELEASES_LAST_30_DAYS: String = "releasesLast30Days"
  val COMPLETION_RATE_MONTH_AGO: String = "completionRateMonthAgo"
  val AVG_RELEASES_PER_DAY_LAST_YEAR: String = "avgReleasesPerDay"
  val AVG_RELEASES_PER_MONTH_LAST_YEAR: String = "avgReleasesPerMonth"
  val RELEASES_WITH_DEPENDENCIES: String = "releasesWithDependencies"
  val TOTAL_DEPENDENCIES: String = "totalDependencies"
  val AVG_DEPENDENCIES_PER_RELEASE: String = "avgDependenciesPerRelease"
  val MAX_DEPENDENCIES_PER_RELEASE: String = "maxDependenciesPerRelease"
  val AVG_TASKS_PER_RELEASE: String = "avgTasksPerRelease"
  val MAX_TASKS_IN_RELEASE: String = "maxTasksInRelease"
  val RELEASE_TAGS: String = "releaseTags"
  val AVG_PHASES_PER_RELEASE: String = "avgPhasesPerRelease"
  val MAX_PHASES_PER_RELEASE: String = "maxPhasesPerRelease"
  val PLUGINS_TASKS_LAST_180_DAYS: String = "pluginTasksLast180Days"
  val CORE_TASKS_LAST_180_DAYS: String = "coreTasksLast180Days"
  val EXT_TASKS_LAST_180_DAYS: String = "extensionTasksLast180Days"
  val MAX_SECURABLE_CI_UID_VALUE: String = "maxSecurableCiUidValue"

  // Task metrics tracked properties
  val PLANNED_TASKS: String = "plannedTasks"
  val PENDING_TASKS: String = "pendingTasks"
  val IN_PROGRESS_TASKS: String = "inProgressTasks"
  val FAILED_TASKS: String = "failedTasks"
  val SKIPPED_TASKS: String = "skippedTasks"
  val COMPLETED_TASKS: String = "completedTasks"
  val ABORTED_TASKS: String = "abortedTasks"
  val TEMPLATE_TASKS:String = "templateTasks"
  val TOP_25_TASK_TYPES_1: String = "top25TaskTypes1"
  val TOP_25_TASK_TYPES_2: String = "top25TaskTypes2"
  val AUTOMATION_PERCENTAGE_METRIC: String = "automationPercentage"
  val TASK_TAGS: String = "taskTags"
  val TASK_BACKUPS: String = "taskBackups"
  val TASK_COMMENTS: String = "comments"
  val TASK_ATTACHMENTS: String = "attachments"
  val MAX_TASKS_CI_UID_VALUE: String = "maxTasksCiUidValue"

  // User metrics tracked properties
  val ALL_USERS: String = "allUsers"
  val ENABLED_USERS: String = "enabledUsers"
  val INTERNAL_USERS: String = "internalUsers"
  val EXTERNAL_USERS: String = "externalUsers"
  val ACTIVE_USERS_LAST_24_HOURS: String = "activeUsersLast24Hours"
  val ACTIVE_USERS_LAST_30_DAYS: String = "activeUsersLast30Days"
  val ACTIVE_USERS_LAST_90_DAYS: String = "activeUsersLast90Days"
  val GLOBAL_ROLES: String = "globalRoles"
  val TEAMS: String = "teams"
  val ROLE_ROLES: String = "roleRoles"
  val ROLE_PRINCIPALS: String = "rolePrincipals"
  val ROLE_PERMISSIONS: String = "rolePermissions"

  // Report metrics tracked properties
  val ACTIVITY_LOGS: String = "activityLogs"
  val ATTRIBUTES_METRIC: String = "attributes"
  val DEPLOYMENTS: String = "deployments"
  val DEPLOYMENT_HISTORIES: String = "deploymentHistories"
  val DEPLOYMENT_RECORDS: String = "deploymentRecords"
  val ITSM_RECORDS: String = "itsmRecords"
  val COMPLIANCE_RECORDS: String = "complianceRecords"
  val BUILD_RECORDS: String = "buildRecords"
  val PLAN_RECORDS: String = "planRecords"
  val ARCHIVED_DEPLOYMENT_RECORDS: String = "archivedDeploymentRecords"
  val ARCHIVED_ITSM_RECORDS: String = "archivedItsmRecords"
  val ARCHIVED_COMPLIANCE_RECORDS: String = "archivedComplianceRecords"
  val ARCHIVED_BUILD_RECORDS: String = "archivedBuildRecords"
  val ARCHIVED_PLAN_RECORDS: String = "archivedPlanRecords"
  val PERMISSION_SNAPSHOTS: String = "permissionSnapshots"
  val TEMPLATE_REVISIONS: String = "templateRevisions"
  val RISK_ASSESSMENTS: String = "riskAssessments"
  val MAX_ACTIVITY_LOG_ID_VALUE: String = "maxActivityLogIdValue"

  // Usage metrics tracked properties
  val GLOBAL_CONNECTIONS: String = "globalConnections"
  val FOLDER_CONNECTIONS: String = "folderConnections"
  val FOLDERS: String = "folders"
  val MAX_FOLDER_DEPTH: String = "maxFolderDepth"
  val GLOBAL_VARIABLES: String = "globalVariables"
  val FOLDER_VARIABLES: String = "folderVariables"
  val AVG_VARIABLES_PER_FOLDER: String = "avgVariablesPerFolder"
  val GLOBAL_DASHBOARDS: String = "globalDashboards"
  val FOLDER_DASHBOARDS: String = "folderDashboards"
  val GROUPS: String = "groups"
  val PATTERNS: String = "patterns"
  val DELIVERIES: String = "deliveries"
  val APPLICATIONS: String = "applications"
  val ENVIRONMENTS: String = "environments"
  val CALENDAR_ENTRIES: String = "calendarEntries"

  // Archive metrics tracked properties
  val ARCHIVING_ENABLED: String = "archivingEnabled"
  val ARCHIVING_AGE: String = "archivingAge"
  val PRE_ARCHIVED_RELEASES: String = "prearchivedReleases"
  val ARCHIVED_RELEASES: String = "archivedReleases"
  val OLDEST_ARCHIVED_RELEASE_DATE: String = "oldestArchivedReleaseDate"
  val ARCHIVED_COMPLETED_RELEASES: String = "archivedCompletedReleases"
  val ARCHIVED_ABORTED_RELEASES: String = "archivedAbortedReleases"
  val ARCHIVED_PHASES: String = "archivedPhases"
  val ARCHIVED_TASKS: String = "archivedTasks"
  val ARCHIVED_ATTACHMENTS: String = "archivedAttachments"
  val ARCHIVED_TAGS: String = "archivedTags"
  val ARCHIVED_ROLES: String = "archivedRoles"
  val ARCHIVED_MEMBERS: String = "archivedMembers"
  val MAX_ARCHIVED_TASKS_UID_VALUE: String = "maxArchivedTasksUidValue"

  // License metrics tracked properties
  val LICENSE_VERSION: String = "version"
  val LICENSED_PRODUCT: String = "product"
  val LICENSE_EDITION: String = "edition"
  val LICENSED_TO: String = "licensesTo"
  val LICENSE_EXPIRATION_DATE: String = "expirationDate"
  val LICENSE_REMAINING_DAYS: String = "remainingDays"
  val LICENSE_UTILIZATION_RATE: String = "utilizationRate"
  val LICENSE_REPOSITORY_ID: String = "repositoryId"
  val LICENSE_MAX_USERS: String = "maxUsers"
  val LICENSE_CURRENT_USERS: String = "currentUsers"

  // Installation metrics tracked properties
  val RELEASE_VERSION: String = "releaseVersion"
  val INSTANCE_NAME: String = "instanceName"
  val HOSTNAME: String = "hostname"
  val SERVER_URL: String = "serverUrl"
  val VM_NAME: String = "vmName"
  val VM_ARGS_1: String = "vmArgs1"
  val VM_ARGS_2: String = "vmArgs2"
  val OS_UP_TIME: String = "upTime"
  val OS_NAME: String = "osName"
  val OS_ARCHITECTURE: String = "osArchitecture"
  val PROCESSORS: String = "processors"
  val MAX_MEMORY: String = "maxMemory"
  val USED_MEMORY: String = "usedMemory"
  val MAIN_DB_TYPE: String = "mainDbType"
  val ARCHIVE_DB_TYPE: String = "archiveDbType"
  val NO_HIT_DB_QUERY_DURATION: String = "noHitDBQueryDuration"
  val HIT_DB_QUERY_DURATION: String = "hitDBQueryDuration"
  val INSTALLED_PLUGINS: String = "officialPlugins"
  val CUSTOM_PLUGINS: String = "customPlugins"
  val PLUGIN_COUNT: String = "totalPluginCount"
  val OFFICIAL_PLUGIN_COUNT: String = "officialPluginCount"
  val CUSTOM_PLUGIN_COUNT: String = "customPluginCount"
  val HOTFIXES: String = "hotfixes"
  val EXTENSION_DIRECTORY: String = "extensions"
  val CLUSTER_MODE: String = "clusterMode"
  val NUMBER_OF_NODES: String = "numberOfNodes"
  val CLUSTER_ACTOR_SYSTEM: String = "clusterActorSystem"
  val CLUSTER_LEADER: String = "clusterLeader"
  val ACTIVE_NODE_DB: String = "activeNodesDB"
  val ACTIVE_NODE_PEKKO: String = "activeNodesPekko"
  val CLUSTER_IS_NODE_ACTIVE: String = "clusterIsNodeActive"

  //Workflow metrics tracked properties
  val WORKFLOWS_USED_LAST_180_DAYS_1: String = "workflowsUsedLast180Days1"
  val WORKFLOWS_USED_LAST_180_DAYS_2: String = "workflowsUsedLast180Days2"
  val STARTED_WORKFLOWS: String = "startedWorkflows"
  val ABORTED_WORKFLOWS: String = "abortedWorkflows"
  val FAILED_WORKFLOWS: String = "failedWorkflows"
  val COMPLETED_WORKFLOWS: String = "completedWorkflows"
  val WORKFLOWS_LAST_24_HOURS: String = "workflowsLast24Hours"
  val WORKFLOWS_LAST_30_DAYS: String = "workflowsLast30Days"
  val WORKFLOW_COMPLETION_RATE_MONTH_AGO: String = "workflowCompletionRateMonthAgo"
  val WORKFLOW_TOP_25_TASK_TYPES_1: String = "workflowTop25TaskTypes1"
  val WORKFLOW_TOP_25_TASK_TYPES_2: String = "workflowTop25TaskTypes2"
  val WORKFLOW_OFFICIAL_TEMPLATES: String = "workflowOfficialTemplates"
  val WORKFLOW_CUSTOM_TEMPLATES: String = "workflowCustomTemplates"
  val ARCHIVED_COMPLETED_WORKFLOWS: String = "archivedCompletedWorkflows"
  val ARCHIVED_ABORTED_WORKFLOWS: String = "archivedAbortedWorkflows"
  val ARCHIVED_WORKFLOWS: String = "archivedWorkflows"
  val PRE_ARCHIVED_WORKFLOWS: String = "prearchivedWorkflows"
  val AVG_TASKS_PER_WORKFLOW: String = "avgTasksPerWorkflow"
  val MAX_TASKS_IN_WORKFLOW: String = "maxTasksInWorkflow"

  val PRIMITIVE_SIZE = 16
  val PRIMITIVE_LONG_DOUBLE_SIZE = 24

}
