package com.xebialabs.xlrelease.pendo.actor

import com.xebialabs.analytics.pendo.PendoDataPublisher
import com.xebialabs.analytics.pendo.PendoDataPublisher.{DisablePublishing, EnablePublishing}
import com.xebialabs.xlrelease.actors.ManagedActor
import com.xebialabs.xlrelease.actors.initializer.ActorInitializerOrder.PENDO_DATA_PUBLISHER
import com.xebialabs.xlrelease.actors.initializer.ManagedActorInitializer
import com.xebialabs.xlrelease.pendo.actor.PendoDataPublisherInitializer.PendoDataPublisherActorHolder


object PendoDataPublisherInitializer {
  type PendoDataPublisherActorHolder = ManagedActor[PendoDataPublisher]
}

class PendoDataPublisherInitializer(pendoDataPublisherActorHolder: PendoDataPublisherActorHolder,
                                    enabled: Boolean)
  extends ManagedActorInitializer {

  override def doStart(): Unit = {
    if (enabled) {
      pendoDataPublisherActorHolder ! EnablePublishing
    } else {
      pendoDataPublisherActorHolder ! DisablePublishing
    }
  }

  override def doStop(): Unit = {
    pendoDataPublisherActorHolder ! DisablePublishing
  }

  override def getOrder: Int = PENDO_DATA_PUBLISHER
}
