package com.xebialabs.xlrelease.pendo.extractors

import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.pendo.PendoConstants._
import org.springframework.stereotype.Component

import java.time.Instant

@Component
class ReleaseCreatedExtractor extends ReleaseEventExtractor[ReleaseCreatedEvent] {

  override def extractPendoData(event: Any): Option[PendoEvent] = {
    event match {
      case ev: ReleaseCreatedEvent => Some(PendoEvent(
        RELEASE_CREATED,
        // TODO ted: check if source mapping works ok
        eventProperties(ev.release) ++ Map(CREATION_SOURCE -> Option(ev.source).map(_.getClass.getSimpleName).getOrElse("Unknown")),
        Instant.now.toEpochMilli
      ))
      case _ => None
    }
  }

  override def supports(): Class[ReleaseCreatedEvent] = classOf[ReleaseCreatedEvent]

}
