package com.xebialabs.xlrelease.pendo

import com.xebialabs.analytics.pendo.{PendoDataExtractor, PendoEventQueue}
import com.xebialabs.xlrelease.domain.events._
import grizzled.slf4j.Logging

// DISABLE SENDING OF UNUSED EVENTS @EventListener
// Temporarily have disabled sending of Release events to Pendo, as they are not used in the current implementation
// and it poses unnecessary load for our system and the Pendo service.
class PendoRelevantEventsListener(pendoSwitch: PendoSwitch, eventQueue: PendoEventQueue, dataExtractors: Map[Class[_], PendoDataExtractor[_]]) extends Logging {

  // DISABLE SENDING OF UNUSED EVENTS @AsyncSubscribe
  def onReleaseCreated(event: ReleaseCreatedEvent): Unit = {
    if (!event.release.isTemplate) {
      processEventData(event)
    }
  }

  // DISABLE SENDING OF UNUSED EVENTS @AsyncSubscribe
  def onReleaseStarted(event: ReleaseStartedEvent): Unit = {
    processEventData(event)
  }

  // DISABLE SENDING OF UNUSED EVENTS @AsyncSubscribe
  def onReleaseFailed(event: ReleaseFailedEvent): Unit = {
    processEventData(event)
  }

  // DISABLE SENDING OF UNUSED EVENTS @AsyncSubscribe
  def onReleaseAborted(event: ReleaseAbortedEvent): Unit = {
    processEventData(event)
  }

  // DISABLE SENDING OF UNUSED EVENTS @AsyncSubscribe
  def onReleaseCompleted(event: ReleaseCompletedEvent): Unit = {
    processEventData(event)
  }

  private def processEventData(releaseEvent: ReleaseEvent): Unit = {
    if (pendoSwitch.isEnabled) {
      dataExtractors.get(releaseEvent.getClass) match {
        case Some(dataExtractor) =>
          dataExtractor.extractPendoData(releaseEvent) match {
            case Some(extractedData) => eventQueue.add(extractedData)
            case None => logger.warn(s"Unable to extract Pendo data for event ${releaseEvent.getClass.getName}, skipping")
          }
        case _ => logger.warn(s"Received unhandled Pendo event notification ${releaseEvent.getClass.getName}")
      }
    }
  }
}
