package com.xebialabs.xlrelease.pendo.extractors

import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent
import com.xebialabs.xlrelease.pendo.PendoConstants._
import org.springframework.stereotype.Component

import java.time.Instant

@Component
class ReleaseFailedExtractor extends ReleaseEventExtractor[ReleaseFailedEvent] {

  override def extractPendoData(event: Any): Option[PendoEvent] = {
    event match {
      case ev: ReleaseFailedEvent => Some(PendoEvent(RELEASE_FAILED, eventProperties(ev.release), Instant.now.toEpochMilli))
      case _ => None
    }
  }

  override def supports(): Class[ReleaseFailedEvent] = classOf[ReleaseFailedEvent]

}
