/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.release.scheduler;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent;
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import scala.Function0;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005=d!\u0002\f\u0018\u0003\u0003!\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")\u0001\u000e\u0001C\u0001S\"9A\u000f\u0001a\u0001\n\u0013)\bb\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\u0007{\u0002\u0001\u000b\u0015B3\t\u000fy\u0004!\u0019!C\u0005\u007f\"9\u0011\u0011\u0001\u0001!\u0002\u0013a\u0004\u0002CA\u0002\u0001\t\u0007I\u0011B@\t\u000f\u0005\u0015\u0001\u0001)A\u0005y!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001B\u0002\r\u0001\r\u0003\tY\u0001\u0003\u0006\u0002\u0014\u0001A)\u0019!C\u0001\u0003+A!\"!\b\u0001\u0011\u000b\u0007I\u0011AA\u0010\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\u000b\u0001\t\u0003\tI\u0003C\u0004\u0002.\u0001!I!!\u000b\t\u000f\u0005=\u0002\u0001\"\u0003\u0002*!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\"a\u0006\"bg\u0016tu\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f\u0015\tA\u0012$A\u0005tG\",G-\u001e7fe*\u0011!dG\u0001\be\u0016dW-Y:f\u0015\taR$\u0001\u0004rk\u0006\u0014HO\u001f\u0006\u0003=}\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0001\n\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0013aA2p[\u000e\u00011\u0003\u0002\u0001&WM\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0019\u0019w.\\7p]*\u0011\u0001'H\u0001\bkB<'/\u00193f\u0013\t\u0011TFA\tDY\u0006\u001c8OT1nKR{7\u000b\u001e:j]\u001e\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000bMdg\r\u000e6\u000b\u0003a\n\u0001b\u001a:jujdW\rZ\u0005\u0003uU\u0012q\u0001T8hO&tw-A\u0006tKJ4\u0018nY3OC6,\u0007CA\u001fE\u001d\tq$\t\u0005\u0002@O5\t\u0001I\u0003\u0002BG\u00051AH]8pizJ!aQ\u0014\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007\u001e\n\u0001B[8c\u00072\f'P\u001f\u0019\u0003\u0013:\u00032!\u0010&M\u0013\tYeIA\u0003DY\u0006\u001c8\u000f\u0005\u0002N\u001d2\u0001A!C(\u0003\u0003\u0003\u0005\tQ!\u0001Q\u0005\ryF%M\t\u0003#R\u0003\"A\n*\n\u0005M;#a\u0002(pi\"Lgn\u001a\t\u0003+fk\u0011A\u0016\u0006\u00039]S\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.W\u0005\rQuNY\u0001\u0017I\u00164\u0017-\u001e7u)JLwmZ3s\u0013:$XM\u001d<bYB\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011mJ\u0001\u000bG>t7-\u001e:sK:$\u0018BA2_\u0005!!UO]1uS>t\u0017a\u00058pi&4\u0017nY1uS>tWI\\1cY\u0016$\u0007C\u0001\u0014g\u0013\t9wEA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0015QG.\u001c:t!\tY\u0007!D\u0001\u0018\u0011\u0015YT\u00011\u0001=\u0011\u00159U\u00011\u0001oa\ty\u0017\u000fE\u0002>\u0015B\u0004\"!T9\u0005\u0013=k\u0017\u0011!A\u0001\u0006\u0003\u0001\u0006\"B.\u0006\u0001\u0004a\u0006\"\u00023\u0006\u0001\u0004)\u0017a\u0002:v]:LgnZ\u000b\u0002K\u0006Y!/\u001e8oS:<w\fJ3r)\tA8\u0010\u0005\u0002's&\u0011!p\n\u0002\u0005+:LG\u000fC\u0004}\u000f\u0005\u0005\t\u0019A3\u0002\u0007a$\u0013'\u0001\u0005sk:t\u0017N\\4!\u0003\u001dQwN\u0019(b[\u0016,\u0012\u0001P\u0001\tU>\u0014g*Y7fA\u0005IqM]8va:\u000bW.Z\u0001\u000bOJ|W\u000f\u001d(b[\u0016\u0004\u0013a\u0004;sS\u001e<WM]%oi\u0016\u0014h/\u00197\u0016\u0003q+\"!!\u0004\u0011\u0007U\u000by!C\u0002\u0002\u0012Y\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u0007)|'-\u0006\u0002\u0002\u0018A\u0019Q+!\u0007\n\u0007\u0005maKA\u0005K_\n$U\r^1jY\u00069AO]5hO\u0016\u0014XCAA\u0011!\r)\u00161E\u0005\u0004\u0003K1&!D*j[BdW\r\u0016:jO\u001e,'/\u0001\u0004sKN,X.\u001a\u000b\u0002q\u0006)\u0001/Y;tK\u0006A1o\u00195fIVdW-\u0001\u0006v]N\u001c\u0007.\u001a3vY\u0016\f\u0011b\u001c8Ti\u0006\u0014H/\u001e9\u0015\u0007a\f)\u0004C\u0004\u00028U\u0001\r!!\u000f\u0002\u000b\u00154XM\u001c;\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u001c\u0003\u0019)g/\u001a8ug&!\u00111IA\u001f\u0005U\u00196\r[3ek2,'o\u0015;beR,G-\u0012<f]RD3!FA$!\u0011\tI%!\u0016\u000e\u0005\u0005-#\u0002BA\u001c\u0003\u001bRA!a\u0014\u0002R\u000591m\u001c8uKb$(bAA*/\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002X\u0005-#!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u00037\u0002B!!\u0018\u0002l5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0006ue\u0006t7/Y2uS>t'\u0002BA3\u0003O\n1a]9m\u0015\r\tI'H\u0001\u0003I\nLA!!\u001c\u0002`\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public abstract class BaseNotificationService
implements ClassNameToString,
Logging {
    private JobDetail job;
    private SimpleTrigger trigger;
    private final String serviceName;
    private Class<? extends Job> jobClazz;
    private final Duration defaultTriggerInterval;
    private final boolean notificationEnabled;
    private boolean running;
    private final String jobName;
    private final String groupName;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public String toString() {
        return ClassNameToString.toString$((ClassNameToString)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private String jobName() {
        return this.jobName;
    }

    private String groupName() {
        return this.groupName;
    }

    public Duration triggerInterval() {
        return this.defaultTriggerInterval;
    }

    public abstract Scheduler scheduler();

    private JobDetail job$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.job = JobBuilder.newJob(this.jobClazz).withDescription(new StringBuilder(4).append(this.serviceName).append(" job").toString()).withIdentity(this.jobName(), this.groupName()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.jobClazz = null;
        return this.job;
    }

    public JobDetail job() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.job$lzycompute() : this.job;
    }

    private SimpleTrigger trigger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(this.jobName(), this.groupName()).withDescription(new StringBuilder(13).append("Trigger ").append(this.serviceName).append(" jobs").toString()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.triggerInterval().toMillis()).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount()).startNow().build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.trigger;
    }

    public SimpleTrigger trigger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.trigger$lzycompute() : this.trigger;
    }

    public void resume() {
        this.scheduler().resumeJob(this.job().getKey());
        this.running_$eq(true);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Started ").append($this.serviceName).append(" service").toString());
    }

    public void pause() {
        this.scheduler().pauseJob(this.job().getKey());
        this.running_$eq(false);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Stopped ").append($this.serviceName).append(" service").toString());
    }

    private void schedule() {
        Date date;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Scheduled ").append($this.serviceName).append(" service").toString());
        if (this.scheduler().checkExists(this.trigger().getKey())) {
            date = this.scheduler().rescheduleJob(this.trigger().getKey(), (Trigger)this.trigger());
        } else {
            this.scheduler().scheduleJob(this.job(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleTrigger[]{this.trigger()}))).asJava(), true);
            date = BoxedUnit.UNIT;
        }
        this.running_$eq(true);
    }

    private void unschedule() {
        block0: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(20).append("Unscheduled ").append($this.serviceName).append(" service").toString());
            if (!this.scheduler().checkExists(this.trigger().getKey())) break block0;
            this.scheduler().unscheduleJob(this.trigger().getKey());
        }
    }

    @EventListener
    public void onStartup(SchedulerStartedEvent event) {
        block3: {
            try {
                if (this.notificationEnabled) {
                    this.schedule();
                    break block3;
                }
                this.unschedule();
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(29).append("Error while starting ").append($this.serviceName).append(" service").toString(), (Function0 & Serializable)() -> e);
            }
        }
    }

    public BaseNotificationService(String serviceName, Class<? extends Job> jobClazz, Duration defaultTriggerInterval, boolean notificationEnabled) {
        this.serviceName = serviceName;
        this.jobClazz = jobClazz;
        this.defaultTriggerInterval = defaultTriggerInterval;
        this.notificationEnabled = notificationEnabled;
        ClassNameToString.$init$((ClassNameToString)this);
        Logging.$init$((Logging)this);
        this.running = false;
        this.jobName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append(serviceName).append(" JOB").toString().toUpperCase()), ' ')).mkString("_");
        this.groupName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(serviceName.toUpperCase()), ' ')).mkString("_");
    }
}

