package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlplatform.cluster.ClusterMode.Full
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_SCHEDULER
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import grizzled.slf4j.Logging
import org.quartz.JobBuilder.newJob
import org.quartz.SimpleScheduleBuilder.simpleSchedule
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{JobDetail, Scheduler, Trigger}
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.event
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ScheduledTaskRecovery(@Qualifier(BEAN_QUARTZ_SCHEDULER) val scheduler: Scheduler) extends Logging {

  val JOB_NAME = "SCHEDULED_TASK_RECOVERY_JOB"
  val GROUP_NAME = "SCHEDULED_TASK_RECOVERY"

  @event.EventListener
  def onStartup(event: SchedulerStartedEvent): Unit = {
    try {
      val job: JobDetail = newJob(classOf[ScheduledTaskRecoveryJob])
        .withDescription(JOB_NAME)
        .withIdentity(JOB_NAME, GROUP_NAME)
        .build()
      val trigger: Trigger = newTrigger()
        .withIdentity(JOB_NAME, GROUP_NAME)
        .withDescription(JOB_NAME)
        .withSchedule(simpleSchedule()
          .withIntervalInMilliseconds(XlrConfig.getInstance.timeouts.nodeFailureDetectionPeriod.toMillis)
          .repeatForever())
        .build()
      XlrConfig.getInstance.clusterMode match {
        case Full => scheduler.scheduleJob(job, Set(trigger).asJava, true)
        case _ => scheduler.deleteJob(job.getKey)
      }
    } catch {
      case e: Exception => logger.error(s"Error while starting ${classOf[ScheduledTaskRecovery].getName} service", e)
    }
  }

}
