package com.xebialabs.xlrelease.quartz.config

import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import grizzled.slf4j.Logging
import org.quartz.Scheduler
import org.springframework.context.ApplicationEventPublisher

class QuartzInitializer(scheduler: Scheduler, eventPublisher: ApplicationEventPublisher)
  extends ActorInitializer with Logging {

  override def initialize(): Unit = {
    try {
      logger.info("Starting Quartz Scheduler")
      scheduler.start()
      eventPublisher.publishEvent(SchedulerStartedEvent(this, scheduler.getSchedulerName))
    } catch {
      case e: Exception => logger.error("Error while starting Quartz scheduler", e)
    }
  }
}
