package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.service.TaskExecutionLogPurgeJob.LOG_PURGE_AGE_KEY
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

object TaskExecutionLogPurgeJob {
  final val LOG_PURGE_AGE_KEY = "executionLogPurgeAge"
}

@DisallowConcurrentExecution
class TaskExecutionLogPurgeJob @Autowired()(service: TaskExecutionLogPurgeService)
  extends Job with Logging {

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing task execution log purge job")
    val daysThreshold = context.getMergedJobDataMap.getInt(LOG_PURGE_AGE_KEY)
    service.run(daysThreshold)
  }
}
